CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 

    IF NOT EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'est_fisco_env') THEN 
		CREATE TABLE est_fisco_env (
			cd_emp numeric NOT NULL DEFAULT 0,
			cd_filial numeric NOT NULL DEFAULT 0,
			cd_cx numeric(6) NOT NULL DEFAULT 0,
			cd_ctr numeric NOT NULL DEFAULT 0,
			dt_ref timestamp NULL,
			tp_arq numeric(1) NOT NULL DEFAULT 0,
			xml_fisco varchar NOT NULL DEFAULT ''::character varying,
			sts_env numeric(1) NOT NULL DEFAULT 0,
			nr_recibo varchar(100) NOT NULL DEFAULT ''::character varying,
			flag_consolidado int4 NULL DEFAULT 0,
			dt_hr_carga timestamp,
			sts_ultimo_env numeric NULL,
			ultima_msg varchar(250) NULL,
			sts_ultimo timestamp,			
			CONSTRAINT est_fisco_env_pkey PRIMARY KEY (cd_emp, cd_filial, cd_cx, cd_ctr)
		)
		WITH (
			OIDS=FALSE
		);	
		RAISE NOTICE 'Tabela est_fisco_env criada' ;
	ELSE 
		RAISE NOTICE 'Tabela est_fisco_env j? existe' ;
    END IF; 

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();
